/******************************************************************************
* (C) Copyright 2007 by Agilent Technologies, All Rights Reserved.
******************************************************************************/

#ifndef PCIEFPGACSSPC_H
#define PCIEFPGACSSPC_H

#include "AgtPCIPort.h"
#include "devpciedefs.h"

class CAgtPCIEControl;

class CPCIEFpgaCSSpc
{
public:

  // = FOUNDATION

  CPCIEFpgaCSSpc();
  ~CPCIEFpgaCSSpc();

  // = ACTION

  //
  // register wrappers
  //
  UInt32 getSiComplStatus( const AgtPortHandleT& portHandle );
  void  setSiComplStatus( const AgtPortHandleT& portHandle, const UInt32& val );
  //
  // functions
  //
  UInt32 getSiComplHeaderDw( const AgtPortHandleT& portHandle, const UInt8& idx );
  UInt32 getSiComplPayloadDW( const AgtPortHandleT& portHandle, const UInt8& idx );
  UInt32 getSiComplHeaderProp( const AgtPortHandleT& portHandle, const EPCIESi& prop );

private:

  // Registers
  UInt32 mSiComplStatus;
  UInt32 mSiComplHeaderDw0;
  UInt32 mSiComplPayloadDW0;

  // helper
  void setBits( UInt32& val, const UInt8& bitPos, const UInt8& bitSize, const UInt32& bitVal );
  UInt32 getBits( const UInt32& val, const UInt8& bitPos, const UInt8& bitSize );
  UInt32 swapDW( const UInt32& val );

  CAgtPCIEControl* myController;
};

#endif /* PCIEFPGACSSPC_H */